#pragma once
#include "xuiapp.h"
#include <xtl.h>
#include <xui.h>
#include <xuiapp.h>
#include <fstream.>
#include "tools.h"
#include "freestyledash.h"
#include "fileslist.h"
#include <vector>

using namespace std;

class CScnFileBrowser :
	public CXuiSceneImpl
{
public:
	CXuiTextElement m_title;
	CXuiTextElement m_copytext;
	CXuiList m_filelist;
	CXuiControl m_back;
	CXuiControl m_drive;
	CXuiControl m_choosedrive;
	CXuiControl m_copy;
	CXuiControl m_cut;
	CXuiControl m_paste;
	CXuiControl m_rename;
	CXuiControl m_delete;
	CXuiControl m_makedir;
	CXuiVideo m_video;
	IXMediaXmvPlayer* xmvPlayer;

	string copysource;
	string copyfile;
	bool IsCut;

	int OverlapFunc;

	vector<string> BasePaths;

	XUI_IMPLEMENT_CLASS( CScnFileBrowser, L"ScnFileBrowser", XUI_CLASS_TABSCENE )

	XUI_BEGIN_MSG_MAP()
		XUI_ON_XM_INIT(OnInit)
        XUI_ON_XM_NOTIFY_PRESS( OnNotifyPress )
		XUI_ON_XM_TIMER( OnTimer )
		XUI_ON_XM_FILES_FILECHANGE( OnFilesChange )
		XUI_ON_XM_FILES_DIRCHANGE( OnDirChange )
		XUI_ON_XM_FILES_FILEPRESS( OnFilePress )
	XUI_END_MSG_MAP()

	HRESULT OnInit(XUIMessageInit *pInitData, BOOL& bHandled);
    HRESULT OnNotifyPress( HXUIOBJ hObjPressed, BOOL& bHandled );
	HRESULT OnTimer( XUIMessageTimer *pTimer, BOOL& bHandled );
	HRESULT OnFilesChange( BOOL& bHandled );
	HRESULT OnFilePress( BOOL& bHandled );
	HRESULT OnDirChange( BOOL& bHandled );
};
